% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{discretise}
\alias{discretise}
\alias{discretise.dist_spec}
\alias{discretize}
\title{Discretise a <dist_spec>}
\usage{
\method{discretise}{dist_spec}(x, strict = TRUE, ...)

discretize(x, ...)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{strict}{Logical; If \code{TRUE} (default) an error will be thrown if a
distribution cannot be discretised (e.g., because no finite maximum has been
specified or parameters are uncertain). If \code{FALSE} then any distribution
that cannot be discretised will be returned as is.}

\item{...}{ignored}
}
\value{
A \verb{<dist_spec>} where all distributions with constant parameters are
nonparametric.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Methodological details}{
The probability mass function of the discretised probability distribution is
a vector where the first entry corresponds to the integral over the (0,1]
interval of the corresponding continuous distribution (probability of
integer 0), the second entry corresponds to the (0,2] interval (probability
mass of integer 1), the third entry corresponds to the (1, 3] interval
(probability mass of integer 2), etc. This approximates the true
probability mass function of a double censored distribution which arises
from the difference of two censored events.
}

\examples{
# A fixed gamma distribution with mean 5 and sd 1.
dist1 <- Gamma(mean = 5, sd = 1, max = 20)

# An uncertain lognormal distribution with meanlog and sdlog normally
# distributed as Normal(3, 0.5) and Normal(2, 0.5) respectively
dist2 <- LogNormal(
  meanlog = Normal(3, 0.5),
  sdlog = Normal(2, 0.5),
  max = 20
)

# The maxf the sum of two distributions
discretise(dist1 + dist2, strict = FALSE)
}
\references{
Charniga, K., et al. “Best practices for estimating and reporting
epidemiological delay distributions of infectious diseases using public
health surveillance and healthcare data”, \emph{arXiv e-prints}, 2024.
\doi{10.48550/arXiv.2405.08841}
Park,  S. W.,  et al.,  "Estimating epidemiological delay distributions for
infectious diseases", \emph{medRxiv}, 2024.
\doi{https://doi.org/10.1101/2024.01.12.24301247}
}
