% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_stan_args}
\alias{create_stan_args}
\title{Create a List of Stan Arguments}
\usage{
create_stan_args(
  stan = stan_opts(),
  data = NULL,
  init = "random",
  model = "estimate_infections",
  fixed_param = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{stan}{A list of stan options as generated by \code{\link[=stan_opts]{stan_opts()}}. Defaults
to \code{\link[=stan_opts]{stan_opts()}}. Can be used to override \code{data}, \code{init}, and \code{verbose}
settings if desired.}

\item{data}{A list of stan data as created by \code{\link[=create_stan_data]{create_stan_data()}}}

\item{init}{Initial conditions passed to \code{{rstan}}. Defaults to "random"
(initial values randomly drawn between -2 and 2) but can also be a
function (as supplied by \code{\link[=create_initial_conditions]{create_initial_conditions()}}).}

\item{model}{Character, name of the model for which arguments are
to be created.}

\item{fixed_param}{Logical, defaults to \code{FALSE}. Should arguments be
created to sample from fixed parameters (used by simulation functions).}

\item{verbose}{Logical, defaults to \code{FALSE}. Should verbose progress
messages be returned.}
}
\value{
A list of stan arguments
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Generates a list of arguments as required by the stan sampling functions by
combining the required options with data, and type of initialisation.
Initialisation defaults to random but it is expected that
\code{\link[=create_initial_conditions]{create_initial_conditions()}} will be used.
}
\examples{
\dontrun{
# default settings
create_stan_args()

# increasing warmup
create_stan_args(stan = stan_opts(warmup = 1000))
}
}
\keyword{internal}
