// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_dist_fit_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'dist_fit', line 20, column 2 to column 42)",
                                                      " (in 'dist_fit', line 21, column 2 to column 27)",
                                                      " (in 'dist_fit', line 22, column 2 to column 41)",
                                                      " (in 'dist_fit', line 23, column 2 to column 45)",
                                                      " (in 'dist_fit', line 24, column 2 to column 44)",
                                                      " (in 'dist_fit', line 27, column 2 to column 41)",
                                                      " (in 'dist_fit', line 28, column 2 to column 40)",
                                                      " (in 'dist_fit', line 30, column 4 to column 60)",
                                                      " (in 'dist_fit', line 31, column 4 to column 57)",
                                                      " (in 'dist_fit', line 29, column 17 to line 32, column 3)",
                                                      " (in 'dist_fit', line 29, column 2 to line 32, column 3)",
                                                      " (in 'dist_fit', line 41, column 4 to column 32)",
                                                      " (in 'dist_fit', line 42, column 4 to column 31)",
                                                      " (in 'dist_fit', line 40, column 24 to line 43, column 3)",
                                                      " (in 'dist_fit', line 40, column 9 to line 43, column 3)",
                                                      " (in 'dist_fit', line 38, column 4 to column 38)",
                                                      " (in 'dist_fit', line 39, column 41 to column 42)",
                                                      " (in 'dist_fit', line 39, column 4 to column 45)",
                                                      " (in 'dist_fit', line 37, column 24 to line 40, column 3)",
                                                      " (in 'dist_fit', line 37, column 9 to line 43, column 3)",
                                                      " (in 'dist_fit', line 36, column 4 to column 73)",
                                                      " (in 'dist_fit', line 35, column 17 to line 37, column 3)",
                                                      " (in 'dist_fit', line 35, column 2 to line 43, column 3)",
                                                      " (in 'dist_fit', line 56, column 6 to line 59, column 8)",
                                                      " (in 'dist_fit', line 55, column 26 to line 60, column 5)",
                                                      " (in 'dist_fit', line 55, column 11 to line 60, column 5)",
                                                      " (in 'dist_fit', line 51, column 6 to line 54, column 8)",
                                                      " (in 'dist_fit', line 50, column 26 to line 55, column 5)",
                                                      " (in 'dist_fit', line 50, column 11 to line 60, column 5)",
                                                      " (in 'dist_fit', line 46, column 6 to line 49, column 8)",
                                                      " (in 'dist_fit', line 45, column 19 to line 50, column 5)",
                                                      " (in 'dist_fit', line 45, column 4 to line 60, column 5)",
                                                      " (in 'dist_fit', line 44, column 15 to line 61, column 3)",
                                                      " (in 'dist_fit', line 44, column 2 to line 61, column 3)",
                                                      " (in 'dist_fit', line 2, column 2 to column 11)",
                                                      " (in 'dist_fit', line 3, column 2 to column 8)",
                                                      " (in 'dist_fit', line 4, column 9 to column 10)",
                                                      " (in 'dist_fit', line 4, column 2 to column 16)",
                                                      " (in 'dist_fit', line 5, column 9 to column 10)",
                                                      " (in 'dist_fit', line 5, column 2 to column 15)",
                                                      " (in 'dist_fit', line 6, column 8 to column 17)",
                                                      " (in 'dist_fit', line 6, column 2 to column 33)",
                                                      " (in 'dist_fit', line 7, column 8 to column 16)",
                                                      " (in 'dist_fit', line 7, column 2 to column 34)",
                                                      " (in 'dist_fit', line 8, column 8 to column 16)",
                                                      " (in 'dist_fit', line 8, column 2 to column 32)",
                                                      " (in 'dist_fit', line 9, column 8 to column 17)",
                                                      " (in 'dist_fit', line 9, column 2 to column 45)",
                                                      " (in 'dist_fit', line 12, column 8 to column 17)",
                                                      " (in 'dist_fit', line 12, column 2 to column 36)",
                                                      " (in 'dist_fit', line 13, column 8 to column 17)",
                                                      " (in 'dist_fit', line 13, column 2 to column 35)",
                                                      " (in 'dist_fit', line 15, column 4 to column 53)",
                                                      " (in 'dist_fit', line 16, column 4 to column 50)",
                                                      " (in 'dist_fit', line 14, column 17 to line 17, column 3)",
                                                      " (in 'dist_fit', line 14, column 2 to line 17, column 3)",
                                                      " (in 'dist_fit', line 20, column 8 to column 17)",
                                                      " (in 'dist_fit', line 21, column 8 to column 17)",
                                                      " (in 'dist_fit', line 22, column 8 to column 17)",
                                                      " (in 'dist_fit', line 23, column 8 to column 17)",
                                                      " (in 'dist_fit', line 24, column 8 to column 17)",
                                                      " (in 'dist_fit', line 27, column 8 to column 17)",
                                                      " (in 'dist_fit', line 28, column 8 to column 17)"};
#include <stan_meta_header.hpp>
class model_dist_fit final : public model_base_crtp<model_dist_fit> {
private:
  int dist;
  int N;
  Eigen::Matrix<double, -1, 1> low;
  Eigen::Matrix<double, -1, 1> up;
  std::vector<double> lam_mean;
  std::vector<double> prior_mean;
  std::vector<double> prior_sd;
  std::vector<double> par_sigma;
  std::vector<double> prior_alpha;
  std::vector<double> prior_beta;
  int lambda_1dim__;
  int mu_1dim__;
  int sigma_1dim__;
  int alpha_raw_1dim__;
  int beta_raw_1dim__;
  int alpha_1dim__;
  int beta_1dim__;
 
public:
  ~model_dist_fit() { }
  
  inline std::string model_name() const final { return "model_dist_fit"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_dist_fit(stan::io::var_context& context__,
                 unsigned int random_seed__ = 0,
                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_dist_fit_namespace::model_dist_fit";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 35;
      context__.validate_dims("data initialization","dist","int",
          context__.to_vec());
      dist = std::numeric_limits<int>::min();
      
      current_statement__ = 35;
      dist = context__.vals_i("dist")[(1 - 1)];
      current_statement__ = 36;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 36;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 37;
      validate_non_negative_index("low", "N", N);
      current_statement__ = 38;
      context__.validate_dims("data initialization","low","double",
          context__.to_vec(N));
      low = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(low, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> low_flat__;
        current_statement__ = 38;
        assign(low_flat__, nil_index_list(), context__.vals_r("low"),
          "assigning variable low_flat__");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 38;
          assign(low, cons_list(index_uni(sym1__), nil_index_list()),
            low_flat__[(pos__ - 1)], "assigning variable low");
          current_statement__ = 38;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 39;
      validate_non_negative_index("up", "N", N);
      current_statement__ = 40;
      context__.validate_dims("data initialization","up","double",
          context__.to_vec(N));
      up = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(up, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> up_flat__;
        current_statement__ = 40;
        assign(up_flat__, nil_index_list(), context__.vals_r("up"),
          "assigning variable up_flat__");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 40;
          assign(up, cons_list(index_uni(sym1__), nil_index_list()),
            up_flat__[(pos__ - 1)], "assigning variable up");
          current_statement__ = 40;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 41;
      validate_non_negative_index("lam_mean", "dist == 0",
                                  logical_eq(dist, 0));
      current_statement__ = 42;
      context__.validate_dims("data initialization","lam_mean","double",
          context__.to_vec(logical_eq(dist, 0)));
      lam_mean = std::vector<double>(logical_eq(dist, 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 42;
      assign(lam_mean, nil_index_list(), context__.vals_r("lam_mean"),
        "assigning variable lam_mean");
      current_statement__ = 43;
      validate_non_negative_index("prior_mean", "dist > 0",
                                  logical_gt(dist, 0));
      current_statement__ = 44;
      context__.validate_dims("data initialization","prior_mean","double",
          context__.to_vec(logical_gt(dist, 0)));
      prior_mean = std::vector<double>(logical_gt(dist, 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 44;
      assign(prior_mean, nil_index_list(), context__.vals_r("prior_mean"),
        "assigning variable prior_mean");
      current_statement__ = 45;
      validate_non_negative_index("prior_sd", "dist > 0", logical_gt(dist, 0));
      current_statement__ = 46;
      context__.validate_dims("data initialization","prior_sd","double",
          context__.to_vec(logical_gt(dist, 0)));
      prior_sd = std::vector<double>(logical_gt(dist, 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 46;
      assign(prior_sd, nil_index_list(), context__.vals_r("prior_sd"),
        "assigning variable prior_sd");
      current_statement__ = 47;
      validate_non_negative_index("par_sigma", "dist == 2",
                                  logical_eq(dist, 2));
      current_statement__ = 48;
      context__.validate_dims("data initialization","par_sigma","double",
          context__.to_vec(logical_eq(dist, 2)));
      par_sigma = std::vector<double>(logical_eq(dist, 2), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 48;
      assign(par_sigma, nil_index_list(), context__.vals_r("par_sigma"),
        "assigning variable par_sigma");
      current_statement__ = 48;
      for (int sym1__ = 1; sym1__ <= logical_eq(dist, 2); ++sym1__) {
        current_statement__ = 48;
        current_statement__ = 48;
        check_greater_or_equal(function__, "par_sigma[sym1__]",
                               par_sigma[(sym1__ - 1)], 0);}
      current_statement__ = 49;
      validate_non_negative_index("prior_alpha", "dist == 2",
                                  logical_eq(dist, 2));
      current_statement__ = 50;
      prior_alpha = std::vector<double>(logical_eq(dist, 2), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 51;
      validate_non_negative_index("prior_beta", "dist == 2",
                                  logical_eq(dist, 2));
      current_statement__ = 52;
      prior_beta = std::vector<double>(logical_eq(dist, 2), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 56;
      if (logical_eq(dist, 2)) {
        current_statement__ = 53;
        assign(prior_alpha, cons_list(index_uni(1), nil_index_list()),
          pow((prior_mean[(1 - 1)] / prior_sd[(1 - 1)]), 2),
          "assigning variable prior_alpha");
        current_statement__ = 54;
        assign(prior_beta, cons_list(index_uni(1), nil_index_list()),
          (prior_mean[(1 - 1)] / pow(prior_sd[(1 - 1)], 2)),
          "assigning variable prior_beta");
      } 
      current_statement__ = 57;
      lambda_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 57;
      lambda_1dim__ = logical_eq(dist, 0);
      current_statement__ = 57;
      validate_non_negative_index("lambda", "dist == 0", lambda_1dim__);
      current_statement__ = 58;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      mu_1dim__ = logical_eq(dist, 1);
      current_statement__ = 58;
      validate_non_negative_index("mu", "dist == 1", mu_1dim__);
      current_statement__ = 59;
      sigma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      sigma_1dim__ = logical_eq(dist, 1);
      current_statement__ = 59;
      validate_non_negative_index("sigma", "dist == 1", sigma_1dim__);
      current_statement__ = 60;
      alpha_raw_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 60;
      alpha_raw_1dim__ = logical_eq(dist, 2);
      current_statement__ = 60;
      validate_non_negative_index("alpha_raw", "dist == 2", alpha_raw_1dim__);
      current_statement__ = 61;
      beta_raw_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      beta_raw_1dim__ = logical_eq(dist, 2);
      current_statement__ = 61;
      validate_non_negative_index("beta_raw", "dist == 2", beta_raw_1dim__);
      current_statement__ = 62;
      alpha_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 62;
      alpha_1dim__ = logical_eq(dist, 2);
      current_statement__ = 62;
      validate_non_negative_index("alpha", "dist == 2", alpha_1dim__);
      current_statement__ = 63;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 63;
      beta_1dim__ = logical_eq(dist, 2);
      current_statement__ = 63;
      validate_non_negative_index("beta", "dist == 2", beta_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += lambda_1dim__;
      num_params_r__ += mu_1dim__;
      num_params_r__ += sigma_1dim__;
      num_params_r__ += alpha_raw_1dim__;
      num_params_r__ += beta_raw_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_dist_fit_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> lambda;
      lambda = std::vector<local_scalar_t__>(lambda_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable lambda");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0, lp__),
            "assigning variable lambda");
        } else {
          current_statement__ = 1;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
            "assigning variable lambda");
        }}
      std::vector<local_scalar_t__> mu;
      mu = std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 3;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      std::vector<local_scalar_t__> alpha_raw;
      alpha_raw = std::vector<local_scalar_t__>(alpha_raw_1dim__, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(alpha_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha_raw");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(alpha_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha_raw[(sym1__ - 1)], 0, lp__),
            "assigning variable alpha_raw");
        } else {
          current_statement__ = 4;
          assign(alpha_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha_raw[(sym1__ - 1)], 0),
            "assigning variable alpha_raw");
        }}
      std::vector<local_scalar_t__> beta_raw;
      beta_raw = std::vector<local_scalar_t__>(beta_raw_1dim__, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable beta_raw");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(beta_raw[(sym1__ - 1)], 0, lp__),
            "assigning variable beta_raw");
        } else {
          current_statement__ = 5;
          assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(beta_raw[(sym1__ - 1)], 0),
            "assigning variable beta_raw");
        }}
      std::vector<local_scalar_t__> alpha;
      alpha = std::vector<local_scalar_t__>(alpha_1dim__, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> beta;
      beta = std::vector<local_scalar_t__>(beta_1dim__, DUMMY_VAR__);
      
      current_statement__ = 11;
      if (logical_eq(dist, 2)) {
        current_statement__ = 8;
        assign(alpha, cons_list(index_uni(1), nil_index_list()),
          (prior_alpha[(1 - 1)] + (par_sigma[(1 - 1)] * alpha_raw[(1 - 1)])),
          "assigning variable alpha");
        current_statement__ = 9;
        assign(beta, cons_list(index_uni(1), nil_index_list()),
          (prior_beta[(1 - 1)] + (par_sigma[(1 - 1)] * beta_raw[(1 - 1)])),
          "assigning variable beta");
      } 
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "alpha[sym1__]",
                               alpha[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "beta[sym1__]",
                               beta[(sym1__ - 1)], 0);}
      {
        current_statement__ = 23;
        if (logical_eq(dist, 0)) {
          current_statement__ = 21;
          lp_accum__.add(
            uniform_lpdf<propto__>(lambda[(1 - 1)],
              (1 / (5. * lam_mean[(1 - 1)])),
              (1 / (0.2 * lam_mean[(1 - 1)]))));
        } else {
          current_statement__ = 20;
          if (logical_eq(dist, 1)) {
            current_statement__ = 16;
            lp_accum__.add(
              normal_lpdf<propto__>(mu[(1 - 1)], prior_mean[(1 - 1)], 10));
            current_statement__ = 17;
            if (logical_lt(sigma[(1 - 1)], 0)) {
              current_statement__ = 17;
              lp_accum__.add(stan::math::negative_infinity());
            } else {
              current_statement__ = 17;
              lp_accum__.add(-normal_ccdf_log(0, prior_sd[(1 - 1)], 10));
            }
            current_statement__ = 18;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma[(1 - 1)], prior_sd[(1 - 1)], 10));
          } else {
            current_statement__ = 15;
            if (logical_eq(dist, 2)) {
              current_statement__ = 12;
              lp_accum__.add(normal_lpdf<propto__>(alpha_raw[(1 - 1)], 0, 1));
              current_statement__ = 13;
              lp_accum__.add(normal_lpdf<propto__>(beta_raw[(1 - 1)], 0, 1));
            } 
          }
        }
        current_statement__ = 34;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 32;
          if (logical_eq(dist, 0)) {
            current_statement__ = 30;
            lp_accum__.add(
              log_diff_exp(exponential_lcdf(up[(i - 1)], lambda),
                exponential_lcdf(low[(i - 1)], lambda)));
          } else {
            current_statement__ = 29;
            if (logical_eq(dist, 1)) {
              current_statement__ = 27;
              lp_accum__.add(
                log_diff_exp(lognormal_lcdf(up[(i - 1)], mu, sigma),
                  lognormal_lcdf(low[(i - 1)], mu, sigma)));
            } else {
              current_statement__ = 26;
              if (logical_eq(dist, 2)) {
                current_statement__ = 24;
                lp_accum__.add(
                  log_diff_exp(gamma_lcdf(up[(i - 1)], alpha, beta),
                    gamma_lcdf(low[(i - 1)], alpha, beta)));
              } 
            }
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_dist_fit_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> lambda;
      lambda = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable lambda");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda");}
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      std::vector<double> alpha_raw;
      alpha_raw = std::vector<double>(alpha_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(alpha_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha_raw");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(alpha_raw, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(alpha_raw[(sym1__ - 1)], 0),
          "assigning variable alpha_raw");}
      std::vector<double> beta_raw;
      beta_raw = std::vector<double>(beta_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable beta_raw");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(beta_raw[(sym1__ - 1)], 0),
          "assigning variable beta_raw");}
      std::vector<double> alpha;
      alpha = std::vector<double>(alpha_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> beta;
      beta = std::vector<double>(beta_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        vars__.emplace_back(lambda[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        vars__.emplace_back(alpha_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        vars__.emplace_back(beta_raw[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 11;
      if (logical_eq(dist, 2)) {
        current_statement__ = 8;
        assign(alpha, cons_list(index_uni(1), nil_index_list()),
          (prior_alpha[(1 - 1)] + (par_sigma[(1 - 1)] * alpha_raw[(1 - 1)])),
          "assigning variable alpha");
        current_statement__ = 9;
        assign(beta, cons_list(index_uni(1), nil_index_list()),
          (prior_beta[(1 - 1)] + (par_sigma[(1 - 1)] * beta_raw[(1 - 1)])),
          "assigning variable beta");
      } 
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "alpha[sym1__]",
                               alpha[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "beta[sym1__]",
                               beta[(sym1__ - 1)], 0);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
          vars__.emplace_back(alpha[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
          vars__.emplace_back(beta[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> lambda;
      lambda = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(lambda, nil_index_list(), context__.vals_r("lambda"),
        "assigning variable lambda");
      std::vector<double> lambda_free__;
      lambda_free__ = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(lambda_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda_free__");}
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(mu, nil_index_list(), context__.vals_r("mu"),
        "assigning variable mu");
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      std::vector<double> sigma_free__;
      sigma_free__ = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      std::vector<double> alpha_raw;
      alpha_raw = std::vector<double>(alpha_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(alpha_raw, nil_index_list(), context__.vals_r("alpha_raw"),
        "assigning variable alpha_raw");
      std::vector<double> alpha_raw_free__;
      alpha_raw_free__ = std::vector<double>(alpha_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(alpha_raw_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(alpha_raw[(sym1__ - 1)], 0),
          "assigning variable alpha_raw_free__");}
      std::vector<double> beta_raw;
      beta_raw = std::vector<double>(beta_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(beta_raw, nil_index_list(), context__.vals_r("beta_raw"),
        "assigning variable beta_raw");
      std::vector<double> beta_raw_free__;
      beta_raw_free__ = std::vector<double>(beta_raw_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(beta_raw_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(beta_raw[(sym1__ - 1)], 0),
          "assigning variable beta_raw_free__");}
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        vars__.emplace_back(lambda_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
        vars__.emplace_back(alpha_raw_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
        vars__.emplace_back(beta_raw_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("lambda");
    names__.emplace_back("mu");
    names__.emplace_back("sigma");
    names__.emplace_back("alpha_raw");
    names__.emplace_back("beta_raw");
    names__.emplace_back("alpha");
    names__.emplace_back("beta");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(lambda_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(sigma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(alpha_raw_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(beta_raw_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(alpha_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" << lambda_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha_raw\",\"type\":{\"name\":\"array\",\"length\":" << alpha_raw_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" << beta_raw_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << alpha_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" << beta_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" << lambda_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha_raw\",\"type\":{\"name\":\"array\",\"length\":" << alpha_raw_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" << beta_raw_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << alpha_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" << beta_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_dist_fit_namespace::model_dist_fit;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_dist_fit_namespace::profiles__;
}
#endif
#endif
