% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_spec_plus}
\alias{dist_spec_plus}
\title{Creates a delay distribution as the sum of two other delay distributions}
\usage{
dist_spec_plus(e1, e2, tolerance = 0.001)
}
\arguments{
\item{e1}{The first delay distribution (from a call to \code{\link[=dist_spec]{dist_spec()}}) to
combine.}

\item{e2}{The second delay distribution (from a call to \code{\link[=dist_spec]{dist_spec()}}) to
combine.}

\item{tolerance}{A numeric value that sets the cumulative probability
to retain when truncating the cumulative distribution function of the
combined nonparametric delays. The default value is 0.001 with this retaining
0.999 of the cumulative probability. Note that using a larger tolerance may
result in a smaller number of points in the combined nonparametric delay but
may also impact the accuracy of the combined delay (i.e., change the mean
and standard deviation).}
}
\value{
A delay distribution representing the sum of the two delays
(with class \code{\link[=dist_spec]{dist_spec()}})
}
\description{
This is done via convolution with \code{stats::convolve()}. Nonparametric delays
that can be combined are processed together, and their cumulative
distribution function is truncated at a specified tolerance level, ensuring
numeric stability.
}
\author{
Sebastian Funk

Sam Abbott
}
