% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{rstan_opts}
\alias{rstan_opts}
\title{Rstan Options}
\usage{
rstan_opts(object = NULL, samples = 2000, method = "sampling", ...)
}
\arguments{
\item{object}{Stan model object. By default uses the compiled package default.}

\item{samples}{Numeric, default 2000. Overall number of posterior samples.
When using multiple chains iterations per chain is samples / chains.}

\item{method}{A character string, defaulting to sampling. Currently supports
\code{rstan::sampling} ("sampling") or \code{rstan:vb} ("vb").}

\item{...}{Additional parameters to pass  underlying option functions.}
}
\value{
A list of arguments to pass to the appropriate rstan functions.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}
Defines a list specifying the arguments passed to underlying \code{rstan}
functions via \code{rstan_sampling_opts} and \code{rstan_vb_opts}.Custom settings can be supplied
which override the defaults.
}
\examples{
rstan_opts(samples = 1000)

# using vb
rstan_opts(method = "vb")
}
\seealso{
rstan_sampling_opts rstan_vb_opts
}
