% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init.net}
\alias{init.net}
\title{Initial Conditions for Stochastic Network Models}
\usage{
init.net(i.num, r.num, i.num.m2, r.num.m2, status.vector, status.rand = FALSE,
  ...)
}
\arguments{
\item{i.num}{Number of initial infected. For bipartite models, this is the
number of initial mode 1 infected.}

\item{r.num}{Number of initial recovered. For bipartite models, this is the
number of initial mode 1 recovered. This parameter is only used for
the \code{SIR} model type.}

\item{i.num.m2}{Number of initial infected in mode 2. This parameter is only
used for bipartite models.}

\item{r.num.m2}{Number of initial recovered in mode 2. This parameter is
only used for bipartite \code{SIR} models.}

\item{status.vector}{A vector of length equal to the size of the input network,
containing the status of each node. Setting status
here overrides any inputs passed in the \code{.num} arguments and also
overrides \code{status.rand=TRUE}.}

\item{status.rand}{If \code{TRUE} and not using \code{status.vector}, sets
infection based on random binomial draws from the distribution implied
by the number infected and recovered in each mode.}

\item{...}{Additional initial conditions passed to model.}
}
\description{
Sets the initial conditions for stochastic network models
             simulated with \code{netsim}.
}
\details{
The initial conditions for a model solved with \code{\link{netsim}} should be
input into the \code{init.net} function. This function handles initial
conditions for both integrated models and new modules. For an overview of
specifying initial conditions across a variety of integrated network models,
consult the \href{http://statnet.github.io/tut/BasicNet.html}{Basic Network
Models} tutorial.
}
\seealso{
Use \code{\link{param.net}} to specify model parameters and
         \code{\link{control.net}} to specify the control settings. Run the
         parameterized model with \code{\link{netsim}}.
}
\keyword{parameterization}

