% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_nwstats}
\alias{get_nwstats}
\title{Extract Network Statistics from Network Epidemic Model}
\usage{
get_nwstats(x, sim, network = 1)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{\link{netsim}}.}

\item{sim}{A vector of simulation numbers from the extracted network.}

\item{network}{Network number, for simulations with multiple networks
representing the population.}
}
\description{
Extracts a data frame of network statistics from a network
             epidemic model.
}
\examples{
## Simulate SI epidemic on bipartite Bernoulli random graph
nw <- network.initialize(n = 100, bipartite = 50, directed = FALSE)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)
param <- param.net(inf.prob = 0.3, inf.prob.m2 = 0.15)
init <- init.net(i.num = 10, i.num.m2 = 10)
control <- control.net(type = "SI", nsteps = 10, nsims = 3,
                       nwstats.formula = ~edges + meandeg + degree(0:5),
                       verbose = FALSE)
mod <- netsim(est, param, init, control)

## Extract the network statistics from simulation 2
get_nwstats(mod)
get_nwstats(mod, sim = c(1,3))

}
\keyword{extract}

