% Generated by roxygen2 (4.0.1): do not edit by hand
\name{epiweb}
\alias{epiweb}
\title{EpiModel Web}
\usage{
epiweb(class)
}
\arguments{
\item{class}{model class, with options of \code{"dcm"} and \code{"icm"}.}
}
\description{
Runs a web browser-based GUI of deterministic compartmental
             models and stochastic individual contact models.
}
\details{
\code{epiweb} runs a web-based GUI of a one-group \code{\link{dcm}} models
and \code{\link{icm}} models with user input on model type, state sizes, and
parameters. Model output may be plotted, summarized, and saved as raw data
using the core \code{EpiModel} functionality for these model classes. These
applications are built using the \code{shiny} package framework.
}
\examples{
\dontrun{
## Deterministic compartmental models
epiweb(class = "dcm")

## Stochastic individual contact models
epiweb(class = "icm")
}
}
\references{
RStudio. shiny: Web Application Framework for R. R package version 0.9.1. 2014.
\url{http://www.rstudio.com/shiny/}
}
\seealso{
\code{\link{dcm}}, \code{\link{icm}}
}
\keyword{GUI}

