
#' @title Modules for Stochastic Network Models
#' 
#' @description 
#' Stochastic network models of infectious disease epidemics simulated through 
#' the network class models require statistical modeling of networks, simulation
#' of those networks forward through time, and simulation of epidemic dynamics on
#' top of those evolving networks. The \code{\link{netsim}} function handles the
#' simulation tasks. Within this function are a series of module functions that
#' initialize the simulation, simulate new infections, new recoveries, and vital 
#' dynamics on the network. Modules also handle the resimulation of the network
#' and some bookkeeping calculations for disease prevalence.
#' 
#' Adding original network models will require modifying the existing modules or
#' adding new modules to the workflow in \code{\link{netsim}}. The design API 
#' for these modules allows for clear replacement and addition of these modules
#' into the simulation.
#' 
#' This help page presents a brief overview of the module functions in the order 
#' in which they are used within \code{\link{netsim}}, in order to help guide 
#' users for writing their own functions. These module functions are not shown 
#' on the main help page index since they are not called directly by the end-user. 
#' Review the help pages for each of these functions for further details.
#' 
#' @section Initialization Module:
#' This function sets up the nodal attributes like disease status on the network
#' at the starting time step of disease simualtion, \eqn{t_1}. For multiple-simulation
#' function calls, these are reset at the beginning of each individual simulation.
#' \itemize{
#'  \item \code{\link{initialize.net}}: sets which nodes are initially infected,
#'        either through the \code{i.num} or \code{i.ids} parameters.
#' }
#'
#' @section Status Modification Modules:
#' The main disease simulation occurs at each time step given the current state
#' of the network at that step. Infection of nodes is simulated as a function of 
#' attributes of the nodes and the edges. Recovery of nodes is likewise simulated
#' as a function of nodal attributes of those infected nodes. These functions 
#' also conduct analysis on the attributes to save summary measures such as 
#' disease incidence.
#' \itemize{
#'  \item \code{\link{infection.net}}: simulates disease transmission given an edgelist
#'        of serodisdant partnerships by calculating the relevant transmission and 
#'        act rates for each edge, and then updated the nodal attributes and 
#'        summary statistics.
#'  \item \code{\link{recovery.net}}: simulates recovery from infection either to a
#'        lifelong immune state (for SIR models) or back to the susceptible state 
#'        (for SIS models), as a function of the recovery rate specified in the
#'        \code{rec.rate} parameter.
#' }
#'  
#'
#' @section Demographic Modules:
#' Vital dynamics such as birth and death processes are simulated at each time
#' step to update entries into and exits from the network. These are used in 
#' dependent network models.
#' \itemize{
#'  \item \code{\link{deaths_sus.net}}: randomly simulates death for susceptible 
#'        status  nodes given the death rate specified in the \code{ds.rate} 
#'        parameter. This involves deactivating or deleting susceptible nodes.
#'  \item \code{\link{deaths_inf.net}}: randomly simulates death for infected status
#'        nodes given the death rate specified in the \code{di.rate} parameter. 
#'        This involves deactivating or deleting infected nodes.
#'  \item \code{\link{deaths_rec.net}}: randomly simulates death for recovered status
#'        nodes given the death rate specified in the \code{dr.rate} parameter. 
#'        This involves deactivating or deleting recovered nodes.
#'  \item \code{\link{births.net}}: randomly simulates new births into the network
#'        given the current population size and the birth rate specified in the 
#'        \code{b.rate} parameter. This involves adding new nodes into the network.
#' }
#'
#' @section Network Resimulation Module:
#' In dependent network models, the network object is resimulated at each time
#' step to account for changes in the size of the network (changed through entries
#' and exits), and the disease status of the nodes.
#' \itemize{
#'  \item \code{\link{resim_nets}}: resimulates the network object one time step
#'        forward given the set of formation and dissolution coefficients estimated
#'        in \code{\link{netest}}. This function also deletes the inactive nodes
#'        if the \code{delete.nodes} control is set to \code{TRUE}.
#' }
#' 
#' @section Bookkeeping Module:
#' Network simulations require bookkeeping at each time step to calculate the
#' summary epidemiological statistics used in the model output analysis.
#' \itemize{
#'  \item \code{\link{get_prev.net}}: calculates the number in each disease state
#'        (susceptible, infected, recovered) at each time step for those active
#'        nodes in the network. If the \code{epi.by} control is used, it calculates
#'        these statistics by a set of nodal attributes.
#' }
#' 
#' 
#' @name modules.net
#' @aliases modules.net
#' 
NULL
