% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summary.dcm}
\alias{summary.dcm}
\title{Summary Model Statistics}
\usage{
\method{summary}{dcm}(object, at, run = 1, digits = 3, ...)
}
\arguments{
\item{object}{an \code{EpiModel} object of class \code{dcm}.}

\item{at}{time step for model statistics.}

\item{run}{model run number, for \code{dcm} class models with multiple runs
(sensitivity analyses).}

\item{digits}{number of significant digits to print.}

\item{...}{additional summary function arguments (not used).}
}
\description{
Extracts and prints model statistics solved with \code{dcm}.
}
\details{
Summary statistics for the main epidemiological outcomes (state and transition
size and prevalence) from an \code{dcm} model. Time-specific summary measures
are provided, so it is necessary to input a time of interest. For multiple-run
models (sensitivity analyses), input a model run number. See examples below.
}
\examples{
## Deterministic SIR model with varying act.rate
param <- param.dcm(inf.prob = 0.2, act.rate = 2:4, rec.rate = 1/3,
                   b.rate = 0.011, ds.rate = 0.01,
                   di.rate = 0.03, dr.rate = 0.01)
init <- init.dcm(s.num = 1000, i.num = 1, r.num = 0)
control <- control.dcm(type = "SIR", nsteps = 50)
mod <- dcm(param, init, control)
summary(mod, at = 25, run = 1)
summary(mod, at = 25, run = 3)
summary(mod, at = 26, run = 3)
}
\seealso{
\code{\link{dcm}}
}
\keyword{extract}

