% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kija_lms.R
\name{lms}
\alias{lms}
\alias{print.lms}
\title{Wrapper around lm for sibling design}
\usage{
lms(formula, data, grp_id, obs_id = NULL, ...)

\method{print}{lms}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{formula}{A formula, used to create a model matrix with demeaned columns.}

\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{grp_id}{<\code{\link[=dplyr_data_masking]{data-masking}}> One unquoted expression
naming the id variable in data defining the groups to demean,
e.g. sibling groups.}

\item{obs_id}{<\code{\link[=dplyr_data_masking]{data-masking}}> Optional, One unquoted
expression naming an id variable to keep track of the input data order.}

\item{...}{Additional arguments to be passed to \link[stats]{lm}(). In print,
additional arguments are ignored without warning.}

\item{x}{An S3 object with class lms.}

\item{digits}{The number of significant digits to be passed to
\link[base]{format}(\link[stats]{coef}(x), .) when \link[base]{print}()ing.}
}
\value{
A list with class \code{c("lms", "lm")}. Contains the output from \code{lm} applied
to demeaned data according to \code{formula}, as well as the original data and the
provided formula.
}
\description{
Fits a linear model using demeaned data. Useful for sibling design.
}
\details{
\code{lms} estimates parameters in the linear model
\deqn{y_{ij_i}=\alpha_i+x_{ij_i}^T\beta + \varepsilon_{ij_i}}{
y_(ij_i)=\alpha_i+x_(ij_i)^T\beta + \varepsilon_(ij_i)}
where \eqn{\alpha_i}{\%\alpha_i} is a group (e.g. sibling group)
specific intercept and \eqn{x_{ij_i}}{\%x_(ij_i)} are covariate values for
observation \eqn{j_i}{\%j_i} in group i.
\eqn{\varepsilon_{ij_i}\sim N(0, \sigma^2)}{\%\varepsilon_(ij_i)~N(0, \sigma^2)}
is a normally distributed error term. It is assumed that interest is in
estimating the vector \eqn{\beta}{\%\beta} while \eqn{\alpha_{i}}{\%\alpha_(i)}
are nuisance parameters. Estimation of \eqn{\beta} uses the mean deviation
method, where
\deqn{y_{ij_i}^{'}=y_{ij_i}-y_i}{y_(ij_i)^(')=y_(ij_i)-y_i}
is regressed on
\deqn{x_{ij_i}^{'}=x_{ij_i}-x_i.}{x_(ij_i)^(')=x_(ij_i)-x_i.}
Here \eqn{y_i} and \eqn{x_i} refers to the mean of y and x in group i.
\cr \code{lms} can keep track of observations by providing a unique identifier
column to \code{obs_id}. \code{lms} will return \code{obs_id} so it matches the order of
observations in model.\cr
\code{lms} only supports syntactic covariate names. Using a non-syntactic name
risks returning an error, e.g if names end in + or -.
}
\examples{
\donttest{
sib_id <- sample(200, 1000, replace = TRUE)
sib_out <- rnorm(200)
x1 <- rnorm(1000)
x2 <- rnorm(1000) + sib_out[sib_id] + x1
y <- rnorm(1000, 1, 0.5) + 2 * sib_out[sib_id] - x1 + 2 * x2
data <- data.frame(
  x1 = x1,
  x2 = x2,
  y = y,
  sib_id = sib_id,
  obs_id = 1:1000
)
mod_lm <- lm(y ~ x1 + x2, data) # OLS model
mod_lm_grp <- lm(y ~ x1 + x2 + factor(sib_id), data) # OLS with grp
mod_lms <- lms(y ~ x1 + x2, data, sib_id, obs_id) # conditional model
summary(mod_lm)
coef(mod_lm_grp)[1:3]
summary(mod_lms)
print(mod_lms)
}
}
\author{
KIJA
}
