% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.ebhistorical.R
\name{summary.ebhistorical}
\alias{summary.ebhistorical}
\title{Summary Method for EpiBayes Historical Object}
\usage{
\method{summary}{ebhistorical}(object, sumstat = "mean", prob = 0.95,
  time.labels = NULL, busterapprox = FALSE, burnin = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{ebhistorical} (e.g., the output of
function \code{\link{EpiBayesHistorical}}).}

\item{sumstat}{The summary statistic that the user wishes to be output. The three choices are \code{mean}, \code{quantile}, and \code{variance}. Character scalar.}

\item{prob}{The probability associated with the quantile one wishes to calculate. Only
used if \code{sumstat} is chosen to be \code{quantile}. Real scalar.}

\item{time.labels}{Labels for the time period axis (e.g., a vector of years). Character
vector.}

\item{busterapprox}{Boolean value indicating whether or not the summary statistics
should be computed using the raw posterior distribution values computed via MCMC
(\code{TRUE}) or using the best beta distribution approximation via moment matching
(\code{FALSE}). Boolean.}

\item{burnin}{Number of MCMC iterations to discard from the beginning of the chain.
Integer scalar.}

\item{...}{Additional arguments to be passed on to summary.}
}
\value{
The summary statistics are returned in a matrix with rows indexed by time period and
    columns indexed by subzone. The body of the matrix is filled with the summary
    statistics requested for by the argument \code{sumstat}.
}
\description{
This function gives summary measurements for posterior distributions of cluster-level
    prevalences across all time periods considered. It does so by examining the object
    output by the \code{\link{EpiBayesHistorical}} function of class
    \code{ebhistorical}.
}
\seealso{
This is a method for objects of class \code{ebhistorical} returned by the function
    \code{\link{EpiBayesHistorical}} and creates its own class of object much like the
    summary method for \code{lm} objects. There is an additional plot method that will
    plot the summary output from this method, \code{summary.ebhistorical}.
}

