% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envnj.R
\name{vdis}
\alias{vdis}
\title{Compute Pairwise Distances Between Vectors}
\usage{
vdis(cos)
}
\arguments{
\item{cos}{a square upper triangular matrix where cos(i,j) is the cosine between the vector i and j.}
}
\value{
A triangular matrix with the distances.
}
\description{
Computes pairwise distances between vectors.
}
\details{
Cosines are standard measure of vector similarity, and can be converted into distance by dij = -log( (1 + cos(i,j) )/2).
}
\examples{
data(bovids)
vectors = otu.space(bovids[, 7:11])
cosData = vcos(vectors)
disData = vdis(cosData)
}
\seealso{
vcos()
}
