% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotCoverage}
\alias{plotCoverage}
\title{Plot the coverage}
\usage{
plotCoverage(logRr, seLogRr, trueLogRr, region = 0.95, fileName = NULL)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025)}

\item{trueLogRr}{A vector of the true effect sizes}

\item{region}{Size of the confidence interval. Default is .95 (95 percent).}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\description{
Plot the coverage
}
\details{
Plot the fractions of estimates where the true effect size is below, above or within the confidence
interval, for one or more true effect sizes.
}
\examples{
data <- simulateControls(n = 50 * 3, mean = 0, sd = 0.15, trueLogRr = log(c(1, 2, 4)))
plotCoverage(data$logRr, data$seLogRr, data$trueLogRr)

}

