% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showPlausibleValues.R
\name{updatePlausibleValue}
\alias{updatePlausibleValue}
\title{Update Plausible Value Variable Names}
\usage{
updatePlausibleValue(oldVar, newVar, data)
}
\arguments{
\item{oldVar}{a character value indicating the existing name of the variable}

\item{newVar}{a character value indicating the new name of the variable}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}
}
\value{
an object of the same class as the \code{data} argument, with the name of
        the plausible value updated from \code{oldVar} to \code{newVar}
}
\description{
Changes the name used to refer to a set of plausible values from \code{oldVar} to \code{newVar} in an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# get the PVs before
showPlausibleValues(data=sdf)
sdf2 <- updatePlausibleValue(oldVar="composite", newVar="overall", data=sdf)
showPlausibleValues(data=sdf2)
lm1 <- lm.sdf(formula=overall ~ b017451, data=sdf2)
summary(lm1)
}
}
\seealso{
\code{\link{getPlausibleValue}} and \code{\link{showPlausibleValues}}
}
\author{
Michael Lee and Paul Bailey
}
