% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readECLS_B.R
\name{readECLS_B}
\alias{readECLS_B}
\title{Connect to ECLS-B Data}
\usage{
readECLS_B(
  path = getwd(),
  filename,
  layoutFilename,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{a character value to the full directory path(s) to the ECLS-B extracted fixed-with-format (.dat) set of datafiles.}

\item{filename}{a character value of the name of the fixed-width-file (.dat) data file in the specificed \code{path} to be read.}

\item{layoutFilename}{a character value of the filename of either the ASCII text (.txt) layout file of the \code{filename} within the specified \code{path},
OR a character value of the  filename of the SPSS syntax (.sps) layout file of the \code{filename} within the specified \code{path}}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readECLS-K2011} function is running to indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
An \code{edsurvey.data.frame} for the ECLS-B longitudinal dataset.
}
\description{
Opens a connection to an ECLS-B data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the ECLS-B longitudinal Database.
}
\seealso{
\code{\link{readNAEP}}, \code{\link{getData}}
}
\author{
Trang Nguyen
}
