% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebindAttributes.R
\name{rebindAttributes}
\alias{rebindAttributes}
\title{Copy Data Frame Attributes}
\usage{
rebindAttributes(data, attributeData)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{attributeData}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}
that contains the desired attributes}
}
\value{
a \code{data.frame} with a class of a \code{light.edsurvey.data.frame} containing
all elements of data and the attributes (except
\code{names} and \code{row.names}) from \code{attributeData}
}
\description{
Many R functions strip attributes from data frame objects. This
             function assigns the attributes from the \code{attributeData} argument
             to the data frame in the \code{data} argument.
}
\examples{
\dontrun{
require(dplyr)
PISA2012 <- readPISA(path = paste0(edsurveyHome, "PISA/2012"),
                     database = "INT",
                     countries = "ALB", verbose=TRUE)
ledf <- getData(data = PISA2012, varnames = c("cnt", "oecd", "w_fstuwt",
                                              "st62q04", "st62q11",
                                              "st62q13", "math"),
                dropOmittedLevels = FALSE, addAttributes = TRUE)

omittedLevels <- c('Invalid', 'N/A', 'Missing', 'Miss', 'NA', '(Missing)')
for (i in c("st62q04", "st62q11", "st62q13")) {
  ledf[,i] <- factor(ledf[,i], exclude=omittedLevels)
  ledf[,i] <- as.numeric(ledf[,i])
}

# after applying some dplyr functions, the "light.edsurvey.data.frame" becomes just "data.frame"
PISA2012_ledf <- ledf \%>\%        
  rowwise() \%>\% 
  mutate(avg_3 = mean(c(st62q04, st62q11, st62q13), na.rm = TRUE)) \%>\% 
  ungroup() \%>\%
  rebindAttributes(PISA2012) # could also be called with ledf
class(PISA2012_ledf) 
# again, a light.edsurvey.data.frame
lma <- lm.sdf(math ~ avg_3,data=PISA2012_ledf)
summary(lma)

PISA2012_ledf <- ledf \%>\%        
  rowwise() \%>\% 
  mutate(avg_3 = mean(c(st62q04, st62q11, st62q13), na.rm = TRUE)) \%>\% 
  ungroup() \%>\%
  rebindAttributes(ledf) # return attributes and make a light.edsurvey.data.frame 
# again a light.edsurvey.data.frame
lma <- lm.sdf(math ~ avg_3,data=PISA2012_ledf)
summary(lma)
}
}
\author{
Paul Bailey and Trang Nguyen
}
