# @author Ahmad Emad and Paul Bailey
# NOT EXPORTED
getAttributes <- function(data, attribute = NULL) {
  # return attributes in a uniform way for either an edesurvey.data.frame or
  # a light.edsurvey.data.frame
  if (!inherits(data, c("edsurvey.data.frame", "light.edsurvey.data.frame"))) {
    print(class(data))
    stop(paste0("The argument ", sQuote("data"), " must be an edsurvey.data.frame or a light.edsurvey.data.frame. See the 'Using the ", 
      dQuote("EdSurvey"), " Package's getData Function to Manipulate the NAEP Primer Data vignette' for how to work with data in a light.edsurvey.data.frame."))
  }
  
  if (inherits(data, c("edsurvey.data.frame"))) {
    # data is an edsurvey.data.frame, so attributes returned in data
    attrs <- attributes(data)$names
  } else {
    # data is not an edsurvey.data.frame, so attributes returned in
    # attributes(data)
    attrs <- names(attributes(data))[!names(attributes(data)) %in% c("names", 
      "class", "row.names")]
  }
  
  if (is.null(attrs) & length(attrs == 0)) {
    stop(paste0(sQuote("data"), " must be an edsurvey.data.frame or generated by a call to getData with a) the ", 
      sQuote("addAttributes"), " argument set to TRUE or b) attributes custom set on a data.frame using attributes()."))
  }
  
  # if attribute searched for is not in defaultAttributes, stop function
  # and return a warning
  if (!(attribute %in% attrs)) {
    stop(paste0(attribute, " not present in ", sQuote("data"),
                ". Attributes must be present in an edsurvey.data.frame, light.edsurvey.data.frame, or data.frame either by a call to getData with a) the ", 
                sQuote("addAttributes"), "argument set to TRUE or b) attributes custom set on a data.frame using attributes()."))
  }
  
  # return the attribute depending on the class of data
  if (inherits(data, c("edsurvey.data.frame"))) {
    attr <- data[[attribute]]
  } else {
    attr <- attributes(data)[[attribute]]
  }
  attr
}
