% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.2geneland.R
\name{eco.2geneland}
\alias{eco.2geneland}
\title{Creating input data for Geneland with an ecogen object}
\usage{
eco.2geneland(eco, ndig)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{ndig}{Number of digits coding each allele (e.g. 1: x, 2: xx or
3: xxx) when data is diploid.}
}
\value{
XY.txt  Matrix with coordinates.

NAMES.txt  Matrix with row names.

P.txt  Matrix with phenotypic data.

G.txt  Matrix with genotypic data.
}
\description{
This function creates four data frames in the working
directory (XY.txt, NAMES.txt, P.txt, G.txt) which can be loaded
in Geneland.
}
\examples{
\dontrun{

data(eco.test)
eco.2geneland(eco, 1)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

