% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglk_miss.R
\name{loglk_miss}
\alias{loglk_miss}
\title{Log likelihood function formed on the basis of the missing-label indicator}
\usage{
loglk_miss(dat, zm, pi, mu, sigma, ncov = 2, xi)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{zm}{An n-dimensional vector of group partition including the missing-label, denoted as NA.}

\item{pi}{A g-dimensional  initial vector of the mixing proportions.}

\item{mu}{A initial  \eqn{p \times g} matrix of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix that \code{sigma} is a \eqn{p\times p} matrix.
\code{ncov} = 2 for the unequal  covariance/scale matrices that
\code{sigma} represents a list of g matrices with dimension \eqn{p\times p \times g}.}

\item{xi}{A 2-dimensional coefficient vector for a logistic function of the Shannon entropy.}
}
\value{
\item{lk}{loglikelihood value}
}
\description{
Log likelihood for partially classified data based on the missing mechanism with the Shanon entropy
}
\details{
The log-likelihood function  formed on the basis of the missing-label indicator can be expressed by
\deqn{
\log L_{PC}^{({miss})}(\theta,\boldsymbol{\xi})=\sum_{j=1}^n\big[ (1-m_j)\log\left\lbrace 1-q(y_j;\theta,\boldsymbol{\xi})\right\rbrace +m_j\log q(y_j;\theta,\boldsymbol{\xi})\big],
}
where \eqn{q(y_j;\theta,\boldsymbol{\xi})} is a logistic function of the Shannon entropy \eqn{e_j(y_j;\theta)},
and  \eqn{m_j} is a missing label indicator.
}
