% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discriminant_beta.R
\name{discriminant_beta}
\alias{discriminant_beta}
\title{Discriminant function}
\usage{
discriminant_beta(pi, mu, sigma)
}
\arguments{
\item{pi}{A 2-dimensional initial vector of the mixing proportions.}

\item{mu}{A initial  \eqn{p \times 2} matrix of the location parameters.}

\item{sigma}{A \eqn{p\times p} common covariance matrix}
}
\value{
\item{beta0}{An intercept of discriminant function}
\item{beta}{A coefficient of discriminant function}
}
\description{
Discriminant function in the particular case of g=2 groups under the equal covariance consideration
}
\details{
Discriminant function in the particular case of g=2 groups under the equal covariance consideration can be expressed
\deqn{d(y_i,\beta)=\beta_0+\beta_1 y_i,}
where \eqn{\beta_0=\log\frac{\pi_1}{\pi_2}-\frac{1}{2}\frac{\mu_1^2-\mu_2^2}{\sigma^2}} and \eqn{\beta_1=\frac{\mu_1-\mu_2}{\sigma^2}}.
}
