% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.l.max.R
\name{test.l.max}
\alias{test.l.max}
\title{Find maximum possible wight transformation value.}
\usage{
test.l.max(X, n = 10, ...)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{n}{\code{Numeric} scalar, number of loop runs and values per loop.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
\code{Numeric} scalar, maximal possible l value.
}
\description{
This function approximates the highest possible value for l in a nested
loop. It uses \code{test.l} and does not need any further parameters. It 
starts with l between zero and 0.5 and iteratively approximates the last 
possible vlaues for which the weight-transformed matrix of the input data
still allows eigenspace extraction.
}
\examples{

## load example data set
data(example_X)

## create weight transformation limits vector
l <- seq(from = 0, to = 0.6, by = 0.02)

## test l.max
l.max <- test.l.max(X = X)



}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180. \cr
Klovan JE, Imbrie J. 1971. An Algorithm and FORTRAN-IV Program for
Large-Scale Q-Mode Factor Analysis and Calculation of Factor Scores.
Mathematical Geology 3: 61-77.
}
\seealso{
\code{\link{EMMA}}, \code{\link{test.l}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
