% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{generate_data}
\usage{
generate_data(n, L, sigma, mu)
}
\arguments{
\item{n}{The number of time moments to generate the data for (vector of length  1, finite positive integer).}

\item{L}{Factor loadings ((m + 1) x k matrix of finite numeric elements: the first m rows correspond to the input measurement equation; the last row corresponds to the transition equation).}

\item{sigma}{Standard deviations of the error/noise terms ((m + 2) x 1 matrix of finite non-negative numeric elements: the first m rows correspond to the input measurement equation; the row before the last one corresponds to the transition equation; the last row corresponds to the output measurement equation).}

\item{mu}{Intercept terms ((m + 1) x 1 matrix of finite numeric elements; the first m rows correspond to the input measurement equation; the last row corresponds to the transition equation).}
}
\value{
A list consisting of 2 elements: 1) observed input data (n x m matrix of numeric elements); 2) observed output differences data (n x 1 matrix of numeric elements).
}
\description{
Generates data according to the one-dimensional cumulative structural equation model with normality assumptions with given model parameter values.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)
generate_data(10, L, sigma, mu)

}
