% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{contr.bayes}
\alias{contr.bayes}
\title{Contrast to enforce equal prior variance on each level}
\usage{
contr.bayes(n)
}
\arguments{
\item{n}{An integer. The number of items for which to create the contrast}
}
\value{
A contrast matrix.
}
\description{
Typical contrasts impose different levels of marginal prior variance for the different levels.
This contrast can be used to ensure that each level has equal marginal priors (Rouder, Morey, Speckman, & Province; 2012).
}
\examples{
{
design_DDMaE <- design(data = forstmann,model=DDM, contrasts = list(E = contr.bayes),
formula =list(v~S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
constants=c(s=log(1)))
}
}
