% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculateMonthlyResults}
\alias{calculateMonthlyResults}
\title{Calculates monthly values of Q, Conc, Flux, FNConc, and FNFlux for the entire record}
\usage{
calculateMonthlyResults(eList)
}
\arguments{
\item{eList}{named list with at least the Daily dataframes}
}
\value{
MonthlyResults data frame of numeric values describing the monthly average values
}
\description{
Computes the monthly mean values of discharge, concentration, flux, flow-normalized concentration and flow-normalized flux (Q, Conc, Flux, FNConc, and FNFlux) in SI units
(For discharge they are in m3/s, concentration is mg/L, and flux is kg/day).
It returns a data frame containing month, year, decimal year, and mean values of DecYear, Q, Conc, Flux, FNConc, and FNFlux.
}
\examples{
eList <- Choptank_eList
monthlyResults <- calculateMonthlyResults(eList)
}
\keyword{statistics}
\keyword{water-quality}

