% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modularity.R
\name{modularity}
\alias{modularity}
\title{Computes the (Signed) Modularity Statistic}
\usage{
modularity(network, memberships, resolution = 1, signed = FALSE)
}
\arguments{
\item{network}{Matrix or data frame.
A symmetric matrix representing a network}

\item{memberships}{Numeric (length = \code{ncol(network)}).
A numeric vector of integer values corresponding to 
each node's community membership}

\item{resolution}{Numeric (length = 1).
A parameter that adjusts modularity to
prefer smaller (\code{resolution} > 1) or larger
(0 < \code{resolution} < 1) communities.
Defaults to \code{1} (standard modularity computation)}

\item{signed}{Boolean (length = 1).
Whether signed or absolute modularity should be computed.
The most common modularity metric is defined by positive values only. 
Gomez et al. (2009) introduced a signed version of modularity that
will discount modularity for edges with negative values. This property
isn't always desired for psychometric networks. If \code{TRUE}, then
this signed modularity metric will be computed. If \code{FALSE}, then
the absolute value of the edges in the network (using \code{abs}) will
be used to compute modularity.
Defaults to \code{FALSE}}
}
\value{
Returns the modularity statistic
}
\description{
Computes (signed) modularity statistic
given a network and community structure. Allows the
resolution parameter to be set
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Estimate EGA
ega.wmt <- EGA(wmt, model = "glasso")

# Compute standard (absolute values) modularity
modularity(
  network = ega.wmt$network,
  memberships = ega.wmt$wc,
  signed = FALSE
)
# 0.1697952

# Compute signed modularity
modularity(
  network = ega.wmt$network,
  memberships = ega.wmt$wc,
  signed = TRUE
)
# 0.1701946

}
\references{
Gomez, S., Jensen, P., & Arenas, A. (2009).
Analysis of community structure in networks of correlated data.
\emph{Physical Review E}, \emph{80}(1), 016114.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> with assistance from GPT-4
}
