% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEML.R
\name{ModelSel}
\alias{ModelSel}
\title{Selection of Superior Models Using MSC Algorithm}
\usage{
ModelSel(df, Alpha, K)
}
\arguments{
\item{df}{Dataframe of predicted values of models with first column as actual values}

\item{Alpha}{Confidence level of MCS tests}

\item{K}{Resampling length}
}
\value{
\itemize{
  \item SelModel: Name of the selected models
}
}
\description{
Selection of Superior Models Using MSC Algorithm
}
\examples{
library("EEML")
Actual<- as.ts(rnorm(200,100,50))
Model1<- as.ts(rnorm(200,100,50))
Model2<- as.ts(rnorm(200,100,50))
Model3<- as.ts(rnorm(200,100,50))
Model4<- as.ts(rnorm(200,100,50))
Model5<- as.ts(rnorm(200,100,50))
DF <- cbind(Actual, Model1,Model2,Model3,Model4,Model5)
SelModel<-ModelSel(df=DF, Alpha=0.2, K=NULL)

}
\references{
\itemize{
\item Paul, R.K., Das, T. and Yeasin, M., 2023. Ensemble of time series and machine learning model for forecasting volatility in agricultural prices. National Academy Science Letters, 46(3), pp.185-188.
\item Yeasin, M. and Paul, R.K., 2024. OptiSembleForecasting: optimization-based ensemble forecasting using MCS algorithm and PCA-based error index. The Journal of Supercomputing, 80(2), pp.1568-1597.
\item  Hansen PR, Lunde A, Nason JM (2011). The model confidence set. Econometrica, 79(2), 453-497
}
}
