% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_uploads.R
\name{get_recent_uploads}
\alias{get_recent_uploads}
\title{Get recent uploads}
\usage{
get_recent_uploads(query, as = "data.frame", env = "production")
}
\arguments{
\item{query}{(character) Query (see details below)}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) A list of zero or more audit records 
of either recently inserted or recently updated data packages.
}
\description{
Get recent uploads
}
\details{
Query parameters are specified as key=value pairs, multiple pairs
must be delimited with ampersands (&), and only a single value should be
specified for a particular key. The following query parameter keys are
allowed:

\itemize{
  \item serviceMethod - Can be: createDataPackage, updateDataPackage
  \item fromTime - An ISO8601 timestamp
  \item limit - A positive whole number
}

The query parameter serviceMethod should have the value "createDataPackage"
(to retrieve recent inserts) or "updateDataPackage" (to retrieve recent
updates). The query parameter fromTime is used to specify the date/time in
the past that represents the oldest audit records that should be returned.
Data packages uploaded prior to that time are not considered recent uploads
and are thus filtered from the query results. The query parameter limit sets
an upper limit on the number of audit records returned. For example,
"limit=3".
}
\examples{
\dontrun{

# Get the 5 most recently created data packages
auditReport <- get_recent_uploads(
 query = "serviceMethod=createDataPackage&limit=5"
)
}
}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_count}()},
\code{\link{get_audit_record}()},
\code{\link{get_audit_report}()},
\code{\link{get_docid_reads}()},
\code{\link{get_packageid_reads}()}
}
\concept{Audit Manager Services}
