% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_eigenvalues.R
\name{fix_eigenvalues}
\alias{fix_eigenvalues}
\title{Modify network to ensure stationarity.}
\usage{
fix_eigenvalues(network, q, gauss_weights)
}
\arguments{
\item{network}{Original network structure, a matrix of size NumNodes by
NumNodes.}

\item{q}{Number of nodes.}

\item{gauss_weights}{If \code{TRUE}, use Gaussian regression weight, if
\code{FALSE} conserve original weights.}
}
\value{
Returns a network with fewer eigenvalues than the original network,
but satisfying the stationarity condition.
}
\description{
This function ensures that the eigenvalues of the network structure matrix
are smaller or equal to 1, thereby ensuring stationarity of the regression.
This is done by removing edges at random until the condition is satisfied.
}
\author{
Frank Dondelinger
}
\seealso{
\code{\link{generateNetwork}}
}

