% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpHyperRatioTarget.R
\name{ExpHyperRatioTarget}
\alias{ExpHyperRatioTarget}
\title{Calculates the ratio of an exponential hyperparameter move.}
\usage{
ExpHyperRatioTarget(beta.proposed, beta.old, target.net, self.loops)
}
\arguments{
\item{beta.proposed}{Proposed new hyperparameter value.}

\item{beta.old}{Previous value of hyperparameter beta.}

\item{target.net}{Network segments for the target node associated with this
hyperparameter value.}

\item{self.loops}{\code{'TRUE'} if self-loops are acceptable, \code{'FALSE'}
otherwise.}
}
\value{
Returns the ratio of the exponential prior with the previous
hyperparameter value and the proposed new hyperparameter value.
}
\description{
This function calculates the acceptance ratio of a level-1 hyperparameter
move for a given target node.
}
\author{
Frank Dondelinger
}
\references{
For information about the exponential information sharing prior,
see:

Husmeier et al. (2010), "Inter-time segment information sharing for
non-homogeneous dynamic Bayesian networks", NIPS.

Dondelinger et al. (2012), "Non-homogeneous dynamic Bayesian networks with
Bayesian regularization for inferring gene regulatory networks with
gradually time-varying structure", Machine Learning.
}
\seealso{
\code{\link{ExpHyperMove}}
}

