% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDA.R
\name{EDA}
\alias{EDA}
\title{Energy consumption analysis for calculating carbon emission changes}
\usage{
EDA(cdata, xdata, Year = Year, Category = Category, Factor = Factor,
  Component = Component, method = "LMDI")
}
\arguments{
\item{cdata}{A data.frame}

\item{xdata}{A list}

\item{Year}{A numeric vector}

\item{Category}{A vector}

\item{Factor}{A vector}

\item{Component}{A vector}

\item{method}{A character chosen from 
"LMDI" or "Laspeyres" or "Paasche" or "Marshall-Edgeworth" or "Walsh"}
}
\description{
Energy consumption analysis for calculating carbon emission changes
}
\examples{
data(CarbonEmission)
carbon <- CarbonEmission$carbon
cdata <- carbon[,-c(1,2)]
xdata <- CarbonEmission$xdata
Year <- carbon$year
Category <- carbon$building
Component <- colnames(carbon[,-c(1:2)])
Factor <- c(1:length(xdata))
EDA(cdata, xdata, Year = Year, Category = Category, Factor = Factor, 
Component = Component, method = "LMDI")

}
