% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{network}
\alias{network}
\alias{network.default}
\alias{network.formula}
\title{Measures of network}
\usage{
network(...)

\method{network}{default}(x, y, measures = "all", eps = 0.15, ...)

\method{network}{formula}(formula, data, measures = "all", eps = 0.15,
  ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{eps}{The percentage of nodes in the graph to be connected.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A list named by the requested network measure.
}
\description{
Classification task. The network measures represent the dataset as a graph 
and extract structural information from it. The transformation between raw 
data and the graph representation is based on the epsilon-NN algorithm. Next,
a post-processing step is applied to the graph, pruning edges between 
examples of opposite classes.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"Density"}{Average Density of the network (Density) represents the 
     number of edges in the graph, divided by the maximum number of edges 
     between pairs of data points.}
   \item{"ClsCoef"}{Clustering coefficient (ClsCoef) averages the clustering 
     tendency of the vertexes by the ratio of existent edges between its 
     neighbors and the total number of edges that could possibly exist 
     between them.}
   \item{"Hubs"}{Hubs score (Hubs) is given by the number of connections it  
     has to other nodes, weighted by the number of connections these 
     neighbors have.}
 }
}
\examples{
## Extract all network measures
data(iris)
network(Species ~ ., iris)
}
\references{
Gleison Morais and Ronaldo C Prati. (2013). Complex Network Measures for 
   Data Set Characterization. In 2nd Brazilian Conference on Intelligent 
   Systems (BRACIS). 12--18.

 Luis P F Garcia, Andre C P L F de Carvalho and Ana C Lorena. (2015). Effect
   of label noise in the complexity of classification problems. 
   Neurocomputing 160, 108--119.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{dimensionality}},
  \code{\link{linearity.class}},
  \code{\link{linearity.regr}}, \code{\link{neighborhood}},
  \code{\link{overlapping}}, \code{\link{smoothness}}
}
\concept{complexity-measures}
