% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeForecastData.R
\name{makeForecastData}
\alias{makeForecastData}
\alias{makeForecastData,ANY-method}
\title{Build a ensemble forecasting data object}
\usage{
makeForecastData(
  .predCalibration = array(NA, dim = c(0, 0, 0)),
  .predTest = array(NA, dim = c(0, 0, 0)),
  .outcomeCalibration = numeric(),
  .outcomeTest = numeric(),
  .modelNames = character(),
  ...
)

\S4method{makeForecastData}{ANY}(
  .predCalibration,
  .predTest,
  .outcomeCalibration,
  .outcomeTest,
  .modelNames
)
}
\arguments{
\item{.predCalibration}{A matrix with the number of rows being the number of observations in the calibration period and a column with calibration period predictions for each model.}

\item{.predTest}{A vector with the number of rows being the number of observations in the test period and a column with test period predictions for each model.}

\item{.outcomeCalibration}{A vector with the true values of the dependent variable for each observation in the calibration period.}

\item{.outcomeTest}{A vector with the true values of the dependent variable for each observation in the test period.}

\item{.modelNames}{A vector of length p with the names of the component models.}

\item{...}{Additional arguments not implemented}
}
\value{
A data object of the class 'ForecastData' with the following slots:
\item{predCalibration}{An array containing the predictions of all component models for all observations in the calibration period.}
\item{predTest}{An array containing the predictions of all component models for all observations in the test period.}
\item{outcomeCalibration}{A vector containing the true values of the dependent variable for all observations in the calibration period.}
\item{outcomeTest}{A vector containing the true values of the dependent variable for all observations in the test period.}
\item{modelNames}{A character vector containing the names of all component models.  If no model names are specified, names will be assigned automatically.}
}
\description{
This function uses the component model forecasts and dependent variable observations provided by the user to create an object of class \code{ForecastData}, which can then be used to calibrate and fit the ensemble. Individual slots of the \code{ForecastData} object can be accessed and changed using the \code{get} and \code{set} functions respectively. Missing predictions are allowed in the calibration set.
}
\examples{

\dontrun{
data(calibrationSample)
data(testSample)
this.ForecastData <- makeForecastData(.predCalibration=calibrationSample[,c("LMER", "SAE", "GLM")],
.outcomeCalibration=calibrationSample[,"Insurgency"],.predTest=testSample[,c("LMER", "SAE", "GLM")],
.outcomeTest=testSample[,"Insurgency"], .modelNames=c("LMER", "SAE", "GLM"))

### to acces individual slots in the ForecastData object
getPredCalibration(this.ForecastData)
getOutcomeCalibration(this.ForecastData)
getPredTest(this.ForecastData)
getOutcomeTest(this.ForecastData)
getModelNames(this.ForecastData)

### to assign individual slots, use set functions

setPredCalibration(this.ForecastData)<-calibrationSample[,c("LMER", "SAE", "GLM")]
setOutcomeCalibration(this.ForecastData)<-calibrationSample[,"Insurgency"]
setPredTest(this.ForecastData)<-testSample[,c("LMER", "SAE", "GLM")]
setOutcomeTest(this.ForecastData)<-testSample[,"Insurgency"]
setModelNames(this.ForecastData)<-c("LMER", "SAE", "GLM")
}

}
