% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{evaluate_model_pro}
\alias{evaluate_model_pro}
\title{Evaluate Prognostic Model Performance}
\usage{
evaluate_model_pro(
  trained_model_obj = NULL,
  X_data = NULL,
  Y_surv_obj,
  sample_ids,
  years_to_evaluate = c(1, 3, 5),
  precomputed_score = NULL,
  meta_normalize_params = NULL
)
}
\arguments{
\item{trained_model_obj}{A trained model object (optional if precomputed_score provided).}

\item{X_data}{Features for prediction (optional if precomputed_score provided).}

\item{Y_surv_obj}{True survival object.}

\item{sample_ids}{Vector of IDs.}

\item{years_to_evaluate}{Numeric vector of years for time-dependent AUC.}

\item{precomputed_score}{Numeric vector of pre-calculated risk scores.}

\item{meta_normalize_params}{Internal use.}
}
\value{
A list containing a dataframe of scores and a list of evaluation metrics.
}
\description{
Comprehensive evaluation of survival models using:
\enumerate{
\item Harrell's Concordance Index (C-index).
\item Time-dependent Area Under the ROC Curve (AUROC) at specified years.
\item Kaplan-Meier analysis comparing high vs. low risk groups (based on median split).
}
}
