% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDrugRestart}
\alias{plotDrugRestart}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.}
\usage{
plotDrugRestart(
  result,
  facetX = "variable_name",
  facetY = c("cdm_name", "cohort_name", "strata"),
  colour = "variable_level",
  splitStrata = TRUE
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseDrugRestart().}

\item{facetX}{Vector of variables to facet by horizontally. Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name"}

\item{facetY}{Vector of variables to facet by vertically Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name".}

\item{colour}{Vector of variables to distinct by colour. Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name", and
"variable_level".}

\item{splitStrata}{Whether to split strata columns.}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.
}
\examples{
\dontrun{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "switch_cohort",
  conceptSet = conceptlist
)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

plotDrugRestart(result)

CDMConnector::cdmDisconnect(cdm = cdm)
}

}
