% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugUse.R
\name{summariseDrugUse}
\alias{summariseDrugUse}
\title{This function is used to summarise the dose table over multiple cohorts.}
\usage{
summariseDrugUse(
  cohort,
  cdm,
  strata = list(),
  drugUseVariables = drugUseColumns(cohort),
  drugUseEstimates = c("median", "q25", "q75"),
  minCellCount = 5
)
}
\arguments{
\item{cohort}{Cohort with drug use variables and strata}

\item{cdm}{cdm_reference generated by CDMConnector}

\item{strata}{Stratification list}

\item{drugUseVariables}{Name of columns with drug use variables}

\item{drugUseEstimates}{Estimates that we want for the columns}

\item{minCellCount}{Below this number counts will be supressed}
}
\value{
A summary of the drug use stratified by cohort_name and strata_name
}
\description{
This function is used to summarise the dose table over multiple cohorts.
}
\examples{
\donttest{
library(DrugUtilisation)
library(PatientProfiles)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
cdm <- generateDrugUtilisationCohortSet(
  cdm, "dus_cohort", getDrugIngredientCodes(cdm, "acetaminophen")
)
cdm$dus_cohort <- cdm$dus_cohort \%>\%
  addDrugUse(cdm, 1125315)
result <- summariseDrugUse(cdm$dus_cohort, cdm)
print(result)

cdm$dus_cohort <- cdm$dus_cohort \%>\%
  addSex(cdm) \%>\%
  addAge(cdm, ageGroup = list("<40" = c(0, 30), ">40" = c(40, 150)))
result <- summariseDrugUse(
  cdm$dus_cohort, cdm, strata = list(
   "age_group" = "age_group", "sex" = "sex",
   "age_group and sex" = c("age_group", "sex")
  )
)
print(result)
}

}
