% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{differential_graph_example}
\alias{differential_graph_example}
\title{Differential graph}
\format{
An iGraph graph object.
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
 Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
differential_graph_example
}
\description{
Exemplary intermediate pipeline output: Differential score graph example data built by
\code{\link[DrDimont]{generate_differential_score_graph}} using the
\link[DrDimont]{interaction_score_graphs_example}.
Consists of one graph containing edge attributes: the differential correlation values as
`differential_score` and the differential interaction score as `differential_interaction_score`.
}
\details{
A subset of the original data by Krug et al. (2020) and randomly sampled metabolite
data from \code{\link[DrDimont]{layers_example}} was used to generate the correlation
matrices, individual graphs and combined graphs. They were created from data
stratified by estrogen receptor (ER) status: `groupA` contains data of ER+
patients and `groupB` of ER- patients.
}
\keyword{datasets}
