% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_targets.R
\name{find_targets}
\alias{find_targets}
\title{[INTERNAL] Filter drug target nodes}
\usage{
find_targets(graphs, target_molecules, interaction_table, annotation, on)
}
\arguments{
\item{graphs}{[list] List of two iGraph graph objects (one for each group)}

\item{target_molecules}{[string] Identifies the type of the target molecules (e.g.,
`protein`). The string must be contained in the `type` column of the annotation data frame.}

\item{interaction_table}{[data.frame] Specifying the interaction of drugs and target molecules.
Must contain a column `drug_name` containing drug names/identifiers and a column named like
the character string given in the `on` argument, which must be an identifier for the targeted
molecule.}

\item{annotation}{[data.frame] Contains the annotation for all the nodes contained in the
combined network. Must contain a column `node_id` (vertex IDs in iGraph graph object) and a
column named like the character string given in the `on` argument, which must be an identifier
for the targeted molecule.}

\item{on}{[string] Defines the ID that is used to match drugs to their targets. Both
supplied data frames (`annotation` and `interaction_table`) must contain a column named like
this character string.}
}
\value{
A named list. Element `target_nodes` is a data frame with column `node_id` (unique node
IDs in the iGraph graph object that are targeted by drugs) and columns `groupA` and `groupB`
(bool values specifying whether the node is contained in the combined graph of the group).
Element `drugs_to_target_nodes` contains a named list: elements are `drug_names` and contain a
vector of node IDs that are their specific targets.
}
\description{
[INTERNAL] Based on the supplied target molecules, interaction table, graph and
annotation this function returns a data frame containing nodes in the network targeted by a
drug and a list containing the drug names as names and a vector of node IDs as keys.
}
