% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PickandsEstimator.R
\name{PickandsEstimator}
\alias{PickandsEstimator}
\title{Pickands Estimator}
\usage{
PickandsEstimator(Ra, tail.size)
}
\arguments{
\item{Ra}{A data set}

\item{tail.size}{Number of observations to be used to estimate the Pickands
estimator}
}
\value{
Value of Pickands estimator
}
\description{
Estimates the Value of Pickands Estimator for a specified data set
and chosen tail size. Notes: (1) We estimate the Pickands Estimator by
looking at the upper tail. (2) The tail size must be less than one quarter
of the total sample size. (3) The tail size must be a scalar.
}
\examples{
# Computes estimated Pickands estimator for randomly generated data.
   Ra <- rnorm(1000)
   PickandsEstimator(Ra, 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

