% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoseFinding-package.R
\docType{data}
\name{glycobrom}
\alias{glycobrom}
\title{Glycopyrronium Bromide dose-response data}
\format{
A data frame with 5 summary estimates (one per dose). Variables:
  A data frame with 5 summary estimates (one per dose). Variables:
 \describe{
   \item{\code{dose}}{a numeric vector containing the dose values}
   \item{\code{fev1}}{a numeric vector containing the least square
     mean per dose}
   \item{\code{sdev}}{a numeric vector containing the standard errors
     of the least square means per dose}
   \item{\code{n}}{Number of participants analyzed per treatment group}
 }
}
\source{
http://clinicaltrials.gov/ct2/show/results/NCT00501852
}
\usage{
data(glycobrom)
}
\description{
Data from a clinical study evaluating Efficacy and Safety of Four Doses of
Glycopyrronium Bromide in Patients With Stable Chronic Obstructive Pulmonary
Disease (COPD).  This data set was obtained from clinicaltrials.gov
(NCT00501852).  The study design was a 4 period incomplete cross-over
design. The primary endpoint is the trough forced expiratory volume in 1
second (FEV1) following 7 days of Treatment.
}
\details{
The data given here are summary estimates (least-square means) for each
dose.
}
\examples{

 ## simulate a full data set with given means and sdv (here we ignore
  ## the original study was a cross-over design, and simulate a parallel
  ## group design)
  simData <- function(mn, sd, n, doses, fixed = TRUE){
    ## simulate data with means (mns) and standard deviations (sd), for
    ## fixed = TRUE, the data set will have observed means and standard
    ## deviations as given in mns and sd
    resp <- numeric(sum(n))
    uppind <- cumsum(n)
    lowind <- c(0,uppind)+1
    for(i in 1:length(n)){
      rv <- rnorm(n[i])
      if(fixed)
        rv <- scale(rv)
      resp[lowind[i]:uppind[i]] <- mn[i] + sd[i]*rv
    }
    data.frame(doses=rep(doses, n), resp=resp)
  }
  data(glycobrom)
  fullDat <- simData(glycobrom$fev1, glycobrom$sdev, glycobrom$n,
                     glycobrom$dose)

}
\keyword{datasets}
