% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVMgof2.R
\name{CVMgof2}
\alias{CVMgof2}
\title{One-Sample Cramér–von Mises Goodness-of-Fit Test}
\usage{
CVMgof2(
  x,
  dist = c("norm", "exp", "unif", "lnorm", "weibull", "gamma", "t", "chisq"),
  ...,
  eps = 1e-15
)
}
\arguments{
\item{x}{A numeric vector of observations.}

\item{dist}{A character string specifying the theoretical distribution. Must be one of
\code{"norm"}, \code{"exp"}, \code{"unif"}, \code{"lnorm"}, \code{"weibull"},
\code{"gamma"}, \code{"t"}, or \code{"chisq"}.}

\item{...}{Distribution parameters passed to the corresponding \code{p} functions
(e.g., \code{mean}, \code{sd}, \code{rate}, \code{df}, etc.).}

\item{eps}{A small value to truncate extreme p-values (default is \code{1e-15}).}
}
\value{
An object of class \code{"htest"} with the following components:
\describe{
  \item{statistic}{The computed Cramér–von Mises test statistic.}
  \item{p.value}{The asymptotic p-value.}
  \item{method}{A description of the test and distribution.}
  \item{data.name}{The name of the data vector.}
}
}
\description{
Performs the one-sample Cramér–von Mises goodness-of-fit (GoF) test to assess whether
a sample comes from a specified distribution using asymptotic p-value approximations.
}
\details{
The test uses the Cramér–von Mises statistic to assess how well the empirical
distribution function (EDF) of the sample agrees with the cumulative distribution
function (CDF) of the specified theoretical distribution. The p-value is computed
using approximation formulas derived from the asymptotic distribution of the test statistic.
}
\examples{
set.seed(123)
x1 <- rnorm(500, mean = 0, sd = 1)
CVMgof2(x1, dist = "norm", mean = 0, sd = 1)

x2 <- rexp(500, rate = 2)
CVMgof2(x2, dist = "exp", rate = 2)

x3 <- runif(200, min = -1, max = 3)
CVMgof2(x3, dist = "unif", min = -1, max = 3)

}
