% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetLowerBoundCopula.R
\name{frechetLowerBound}
\alias{frechetLowerBound}
\alias{cFrechetLowerBound}
\alias{crFrechetLowerBound}
\title{Fréchet Lower Bound Copula}
\usage{
cFrechetLowerBound(u1, u2, ...)

crFrechetLowerBound(numberSimulations = 10000, seed = 42)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{cFrechetLowerBound}}}{ returns the value of the copula.}
    \item{\code{\link{crFrechetLowerBound}}}{ returns simulated values of the copula.}
  }
}
\description{
Computes CDF and simulations of the Fréchet lower bound copula.
}
\details{
The Fréchet lower bound copula has CDF :
  \deqn{C(u_{1}, u_{2}) = \max(u_{1} + u_{2} - 1, 0)}{C(u1, u2) = max(u1 + u2 - 1, 0)}
  for \eqn{u_{1}, u_{2} \in [0, 1]}{0 <= u1, u2 <= 1}.
}
\examples{
cFrechetLowerBound(u1 = .76, u2 = 0.4)

crFrechetLowerBound(numberSimulations = 10, seed = 42)

}
