% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateEFGMCopula.R
\name{bivariateEFGM}
\alias{bivariateEFGM}
\alias{cBivariateEFGM}
\alias{cdBivariateEFGM}
\alias{crBivariateEFGM}
\title{Bivariate Eyraud-Farlie-Gumbel-Morgenstern (EFGM) Copula}
\usage{
cBivariateEFGM(u1, u2, dependencyParameter)

cdBivariateEFGM(u1, u2, dependencyParameter)

crBivariateEFGM(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{cBivariateEFGM}}}{ returns the value of the copula.}
    \item{\code{\link{cdBivariateEFGM}}}{ returns the value of the density function associated to the copula.}
    \item{\code{\link{crBivariateEFGM}}}{ returns simulated values of the copula.}
  }
}
\description{
Computes CDF, PDF and simulations of the EFGM copula.
}
\details{
The EFGM copula has CDF :
}
\examples{
cBivariateEFGM(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

cdBivariateEFGM(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

crBivariateEFGM(numberSimulations = 10, seed = 42, dependencyParameter = 0.2)

}
