% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_lnorm.R
\name{Etronq_lnorm}
\alias{Etronq_lnorm}
\title{Truncated mean of the Lognormal distribution}
\usage{
Etronq_lnorm(d, meanlog, sdlog, less.than.d = TRUE)
}
\arguments{
\item{d}{cut-off value.}

\item{meanlog}{location parameter \eqn{\mu}{mu}.}

\item{sdlog}{standard deviation \eqn{\sigma}{sigma}, must be positive.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{E_lnorm}}}{ gives the expected value.}
 \item{\code{\link{V_lnorm}}}{ gives the variance.}
 \item{\code{\link{kthmoment_lnorm}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_lnorm}}}{ gives the truncated mean.}
 \item{\code{\link{SL_lnorm}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_lnorm}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_lnorm}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_lnorm}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_lnorm}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Lognormal distribution with mean
 \eqn{\mu}{mu} and variance \eqn{\sigma}{sigma}.
}
\details{
The Log-normal distribution with mean \eqn{\mu}{mu} and standard deviation
  \eqn{\sigma}{sigma} has density:
  \deqn{\frac{1}{\sqrt{2\pi}\sigma x}\textrm{e}^{-\frac{1}{2}\left(\frac{\ln(x) - \mu}{\sigma}\right)^2}}{f(x) = e^(-(1/2) ((ln(x) - mu)/sigma)^2) / ((2 pi)^(1/2) sigma x}
  for \eqn{x \in \mathcal{R}^{+}}{x >= 0}, \eqn{\mu \in \mathcal{R}, \sigma > 0}{mu real, sigma > 0}.
}
\examples{

Etronq_lnorm(d = 2, meanlog = 2, sdlog = 5)

}
\seealso{
Other Lognormal distribution: 
\code{\link{E_lnorm}()},
\code{\link{Elim_lnorm}()},
\code{\link{Mexcess_lnorm}()},
\code{\link{SL_lnorm}()},
\code{\link{TVaR_lnorm}()},
\code{\link{V_lnorm}()},
\code{\link{VaR_lnorm}()},
\code{\link{kthmoment_lnorm}()}
}
\concept{Lognormal distribution}
