% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_appli.R
\name{fast.Discrete}
\alias{fast.Discrete}
\title{Fast application of discrete procedures}
\usage{
fast.Discrete(counts, alternative = "greater", input = "noassoc",
  alpha = 0.05, direction = "su", adaptive = FALSE)
}
\arguments{
\item{counts}{a data frame of 2 or 4 columns and any number of lines,
each line representing a 2 x 2 contingency table to test.
The number of columns and what they must contain depend on the value of the \code{input} argument, 
see Details of \code{\link{fisher.pvalues.support}}.}

\item{alternative}{same argument as in \code{\link{fisher.test}}. The three possible values are \code{"greater"} 
(default), \code{"two.sided"} or \code{"less"} and you can specify just the initial letter.}

\item{input}{the format of the input data frame, see Details of \code{\link{fisher.pvalues.support}}.
The three possible values are \code{"noassoc"} 
(default), \code{"marginal"} or \code{"HG2011"} and you can specify just the initial letter.}

\item{alpha}{the target FDR level, a number strictly between 0 and 1.}

\item{direction}{a character string specifying whether to conduct a step-up (\code{direction="su"}, by default) or step-down procedure (\code{direction="sd"}).}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}
}
\value{
A list whose elements are:
\item{Rejected}{Rejected raw p-values}
\item{Indices}{Indices of rejected hypotheses}
\item{k.hat}{Number of rejections}
\item{Alpha}{Maximum significance level for the transformed p-values for which a rejection occured, that is \eqn{Alpha = alpha * k.hat / m}}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}
}
\description{
Apply the [HSU], [HSD], [AHSU] or [AHSD] procedure,
without computing the critical constants,
to a data set of 2 x 2 contingency tables using Fisher's exact tests.
}
\details{
This version: 2018-11-13.
}
\examples{

X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

DBH.su <- fast.Discrete(counts = df, input = "noassoc", direction = "su")
DBH.sd <- fast.Discrete(counts = df, input = "noassoc", direction = "sd")
DBH.sd$Adjusted
ADBH.su <- fast.Discrete(counts = df, input = "noassoc", direction = "su", adaptive = TRUE)
ADBH.sd <- fast.Discrete(counts = df, input = "noassoc", direction = "sd", adaptive = TRUE)
ADBH.sd$Adjusted

}
