% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseTD.R
\name{SparseTD}
\alias{SparseTD}
\title{High-Dimensional Temporal Disaggregation}
\usage{
SparseTD(
  Y,
  X = matrix(data = rep(1, times = nrow(Y)), nrow = nrow(Y)),
  penalty = "lasso",
  aggMat = "sum"
)
}
\arguments{
\item{Y}{The low-frequency response vector.}

\item{X}{The high-frequency indicator matrix.}

\item{penalty}{Nominates the choice of regularisation ('lasso' or 'adalasso').}

\item{aggMat}{Aggregation matrix according to 'first', 'sum', 'average', 'last'.}
}
\value{
y_Est  Estimated high-frequency response series.

beta_Est Estimated coefficient vector.

rho_Est  Estimated residual autocorrelation parameter.

ul_Est Estimated aggregate residual series.

lambda Tuning parameter used for lasso/adalasso.
}
\description{
This function provides the Sparse Temporal Disaggregation (spTD) methods proposed by \insertCite{mosley2021sparse;textual}{DisaggregateTS}
to perform temporal disaggregation of time series data in both standard and high-dimensional settings. Variable selection is also
performed by a LASSO penalty \insertCite{tibshirani1996regression;textual}{DisaggregateTS} or an Adaptive LASSO penalty
\insertCite{zou2006adaptive;textual}{DisaggregateTS}.
}
\examples{
data = TempDisaggDGP(n_l=50,m=4,p=10,beta=3,sparsity=0.5,method='Chow-Lin',rho=0.5)
X = data$X_Gen
Y = data$Y_Gen
fit_spTD = SparseTD(Y=Y, X=X)
y_hat = fit_spTD$y_Est
}
\references{
\insertAllCited{}
}
\keyword{Disaggregation}
\keyword{Lasso}
\keyword{Series}
\keyword{Sparse}
\keyword{Temporal}
\keyword{Time}
