% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_set.R
\name{roots}
\alias{roots}
\title{One Dimensional Multiple Roots (Zero) Finding}
\usage{
roots(
  f,
  interval,
  maxerror_f = 1e-07,
  split = "seq",
  split.size = 11,
  tol = .Machine$double.eps^0.25,
  ...
)
}
\arguments{
\item{f}{Function to find roots}

\item{interval}{bounds to inverse in}

\item{maxerror_f}{the maximum error on f evaluation (iterates over uniroot to converge).}

\item{split}{function or "unif" or "seq" (default) to preform interval partition}

\item{split.size}{number of parts to perform uniroot inside}

\item{tol}{the desired accuracy (convergence tolerance on f arg).}

\item{...}{additional named or unnamed arguments to be passed to f.}
}
\value{
array of x, so f(x)=target
}
\description{
Search multiple roots of 1D function, sampled/splitted by a (1D) mesh
}
\examples{
roots(sin,interval=c(pi/2,5*pi/2))
roots(sin,interval=c(pi/2,1.5*pi/2))

f=function(x)exp(x)-1;
f(roots(f,interval=c(-1,2)))

f=function(x)exp(1000*x)-1;
f(roots(f,interval=c(-1,2)))
}
