% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{sectionview}
\alias{sectionview}
\title{Plot a section view of a kriging or modelPredict model including design points, or a function.}
\usage{
sectionview(model, ...)
}
\arguments{
\item{model}{an object of class \code{"km"}, a list that can be used in a \code{"modelPredict"} call, or a function.}

\item{...}{other arguments of the \code{contourview.km}, \code{contourview.list} or \code{contourview.function} function}
}
\description{
Plot one section view per dimension of a kriging, \code{modelPredict} model or function. It is useful for a better understanding of a model behaviour (including uncertainty).
}
\examples{
## A 2D example - Branin-Hoo function
## a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- expand.grid(seq(0, 1, length = 4), seq(0, 1, length = 4))
design.fact <- data.frame(design.fact); names(design.fact) <- c("x1", "x2")
y <- branin(design.fact)

## kriging model 1 : matern5_2 covariance structure, no trend, no nugget effect
m1 <- km(design = design.fact, response = y)

sectionview(m1, center = c(.333, .333))

sectionview(branin, dim = 2, center = c(.333, .333), add=TRUE)
}
