% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deselect_edges.R
\name{deselect_edges}
\alias{deselect_edges}
\title{Deselect any selected edges in a graph}
\usage{
deselect_edges(graph, edges)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edges}{A vector of edge IDs that should be deselected.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Deselect edges in a graph object of class \code{dgr_graph}.
}
\examples{
# Create a graph with
# a single path
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Select edges with IDs `1`
# and `3`
graph <-
  graph \%>\%
  select_edges_by_edge_id(
    edges = c(1, 3))

# Verify that an edge selection
# has been made
graph \%>\% get_selection()

# Deselect edge `1`
graph <-
  graph \%>\%
  select_edges_by_edge_id(
    edges = c(1, 3)) \%>\%
  deselect_edges(edges = 1)

# Verify that the edge selection
# has been made for edges `1` and
# `3` and that edge `1` has been
# deselected (leaving only `3`)
graph \%>\% get_selection()

}
