% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_edge_attrs.R
\name{recode_edge_attrs}
\alias{recode_edge_attrs}
\title{Recode a set of edge attribute values}
\usage{
recode_edge_attrs(graph, edge_attr_from, ..., otherwise = NULL,
  edge_attr_to = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr_from}{the name of the edge attribute
column from which values will be recoded.}

\item{...}{single-length character vectors with
the recoding instructions. The first component should
have the value to replace and the second should have
the replacement value (in the form
\code{"[to_replace] -> [replacement]", ...}).}

\item{otherwise}{an optional single value for
recoding any unmatched values.}

\item{edge_attr_to}{an optional name of a new edge
attribute to which the recoded values will be
applied. This will retain the original edge
attribute and its values.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Within a graph's internal edge data
frame (edf), recode character or numeric edge
attribute values. Optionally, one can specify a
replacement value for any unmatched mappings.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    4, 6, set_seed = 23) \%>\%
  set_edge_attrs(
    "rel",
    c("a", "b", "a",
      "c", "b", "d"))

# Get the graph's internal edf to show which
# edge attributes are available
get_edge_df(graph)
#>   id from to rel
#> 1  1    2  4   a
#> 2  2    1  4   b
#> 3  3    2  3   a
#> 4  4    3  4   c
#> 5  5    1  3   b
#> 6  6    1  2   d

# Recode the `rel` node attribute, creating a
# new edge attribute called `penwidth`; here,
# `a` is recoded to `1.0`, `b` maps to `1.5`, and
# all other values become `0.5`
graph <-
  graph \%>\%
  recode_edge_attrs(
    "rel",
    "a -> 1.0",
    "b -> 1.5",
    otherwise = 0.5,
    edge_attr_to = "penwidth")

# Get the graph's internal edf to show that the
# node attribute values had been recoded and
# copied into a new node attribute
get_edge_df(graph)
#>   id from to rel penwidth
#> 1  1    2  4   a      1.0
#> 2  2    1  4   b      1.5
#> 3  3    2  3   a      1.0
#> 4  4    3  4   c      0.5
#> 5  5    1  3   b      1.5
#> 6  6    1  2   d      0.5
}

